/*---------------------------------------------*\
|  Network Sockets Class - Client and Server	|
|  Easy-to-use functions for setting up client	|
|  and server connections for programs		|
|  						|
|  Adam Honse, Dec. 12 2009, based on info from	|
|    Beej's Guide to Network Programming	|
\*---------------------------------------------*/

#include <iostream>
#include <string>
#include <cstring>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <cstdio>

using namespace std;

class NetworkServer
{
public:

  void Init(int pt);
  void Accept();  //Accept incoming connections
  int Send(char *data, int size);
  int Receive(char *data, int size);

private:

  addrinfo hints;
  addrinfo *result;
  sockaddr_storage their_addr;
  int servfd; //This computer's file descriptor
  int clientfd;//Other computer's file descriptor
  int port;
};

class NetworkClient
{
public:
  void Init(int port, string hostname);
  void Connect(); //Connect to server
  int Send(char *data, int size);
  int Receive(char *data, int size);
private:
  addrinfo hints;
  addrinfo *result;
  sockaddr_storage serv_addr;
  int servfd;
  int port;
};
